/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\
 *                                                                          *
 * FILE NAME:   main.c                                                      *
 *                                                                          *
 * DESIGNER:	Kovacs, Krisztian; Lukacs, Miklos                           *
 * PROGRAMMER: Kovacs, Krisztian; Lukacs, Miklos; Szell Andras              *
 *                                                                          *
 * DESCRIPTION: EZMac test environment                                      *
 *                                                                          *
 * REVISION:    01_2  March  04, 2005   deviation 75kHz                     *
 *              01_3  March  23, 2005   Transmit and receive packet lenght  *
 *                                      can be different in fixed leght mode*
 *              01_4  April  20, 2005   EZradio initialization fime tuning, *
 *                                      Wake-up timer is in on state        *
 *                                      between Wake_Up() and Sleep()       *
 *                                      (not correct POR fix)               *
 *              01_5  May    24, 2005                                       *
 *              01_6  Aug    11, 2005                                       *
 *				01_7  Dec	 08, 2005	Port to HiTech						*
 *                                                                          *
\* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "IAI_EZMac_PIC.c"

//===============================================================================================
// system initialization
#pragma separate
void MAIN_init(void)
{
   #ifdef END_HARDWARE
   setup_adc_ports(AN0);

   #else
   set_tris_C(0x90);
   setup_adc_ports(AN0);

   PB1_DIR = 1;
   PB2_DIR = 1;
   PB3_DIR = 1;
   PB4_DIR = 1;
   #endif                                                     
}

//----------------------------------------------------------------------------
#ifdef END_HARDWARE

#define OFF 0
#define GREEN  2
#define RED  3

void Switch_2color_LED (char func)
{
   switch(func)
   {
   case OFF:
      output_high (PIN_C3);
      output_high (PIN_C4);
      break;

   case GREEN:
      output_low (PIN_C4);
      output_high (PIN_C3);
      break;

   case RED:
      output_low (PIN_C3);
      output_high (PIN_C4);
      break;
   }
}
#endif      //#ifdef END_HARDWARE


//===============================================================================================
#pragma separate
void PrintPacket(void)
{
int8 Buffer[16];
int8 i,Value,Header[5];

   //read the buffer
   EZMacBuf_Read(Buffer); // Packet content read, Trixie is switched off

   //read the Rx Status reg and the header
   EZMacReg_Read(RSR,&Header[0]);
   EZMacReg_Read(R_CID,&Header[1]);
   EZMacReg_Read(SID,&Header[2]);
   EZMacReg_Read(DID,&Header[3]);
   EZMacReg_Read(RPL,&Header[4]);
   //print the status register
   printf("RSR: %x, Packet: ",Header[0]);
   //print the header
   for(i=1;i<5;i++)
      printf("%x ",Header[i]);
   printf("  ");
   //print the Data
   for(i=0;i<Header[4];i++)
      printf("%x ",EZ_reg.bits.DBuff[i]);
   printf("\n\r");
}

//===============================================================================================
#pragma separate
void Device_Test(void)
{
   int8 i,iRet,Freq,TR_String[3];
   static int16 PacketNmbr;
   static BOOL Receiving,Transmitting;


   #define device_rx_all              //device 103
   //#define device_tx                  //device 105

   //Init the devices
   EZMacReg_Write (MCR,0x2B);		//ciden, 4 freq
   EZMacReg_Write (TCR,0x08);      //lbten,+3dB,0.freq
   EZMacReg_Write (RPL,0x03);  		//added for ver1.3 test -> the device will receive 3 bytes
   EZMacReg_Write (CID,0xCD);

   //set the freq registers
   EZMacReg_Write (F0,1);
   EZMacReg_Write (F1,15);
   EZMacReg_Write (F2,30);
   EZMacReg_Write (F3,45);
   #define TCR_VALUE 0x08          //lbten,+3dB,0.freq
	
  #ifdef device_rx_all               //receive: no filter; transmit: none
    EZMacReg_Write (SFID,0x03);
    EZMacReg_Write (CID,0xCE);		//
    EZMacReg_Write (RCR,0x08);      //schen,0.freq
    EZMacReg_Write (SMSK,0x07);     
    EZMacReg_Write (SFLT,0x0F);     
    EZMacReg_Write (PFCR,0x02);     //
    EZMacReg_Write (FMASK,0xF0);    //F[7-4] are masked
   #define device_rx
  #endif

  #ifdef device_tx                   //receive: none; transmit: in for channel
   EZMacReg_Write (RCR,0x09);      //schen,1.freq
   EZMacReg_Write (PFCR,0x02);     //promiscus
   EZMacReg_Write (FMASK,0xfE);    //F[7-4] are masked
   EZMacReg_Write (SFID,0x06);
   #endif

   //wake up the boards
   EZMac_Wake_Up();
   //wait for waking up
   do {
      EZMacReg_Read(MSR,&iRet);
   }while(iRet != EZMac_S_Idle);

   Freq = 0;
   PacketNmbr = 0;

   while(1)
   {
      //switch off the LED
      #ifdef END_HARDWARE
      Switch_2color_LED (OFF);
      #else
      output_high (PIN_C2);                      //switch off
      output_high (PIN_C5);                      //switch off
      #endif      //#ifdef END_HARDWARE

//RX Device
#ifdef device_rx                           //all receiving device
      EZMac_Idle();
      EZMac_Receive();
      Receiving = TRUE;
      //wait for receiving
      while( Receiving )
      {
         EZMacReg_Read(MSR,&iRet);
         if (iRet==EZMac_S_PacketValid)                       //wait for a valid packet
         {
            //switch on the LED
            #ifdef END_HARDWARE
            Switch_2color_LED (GREEN);
            #else
            output_low (PIN_C2);
            #endif      //#ifdef END_HARDWARE
            //print the packet
            PrintPacket();
            //wait for see the LED
            delay_ms(20);
            //end of receiving
            Receiving = FALSE;
         }
      }

//TX device
#else
      //wait for send the packet
      for(i=0;i<15;i++)                   //5s
      delay_ms(100);

      //LED on
      #ifdef END_HARDWARE
      output_low (PIN_C5);                      //switch on red LED
      #else
      output_low (PIN_C1);                      //switch on
      #endif      //#ifdef END_HARDWARE
      //set and send the packet
      //set the Frequency
      EZMacReg_Write(TCR,((TCR_VALUE & 0xF8 ) | Freq));
      if((Freq == 0) || (Freq == 2))
         EZMacReg_Write(DID,0x03);                 //sent to
      else
         EZMacReg_Write(DID,0xFF);                 //sent to
      //set packet length
      EZMacReg_Write(PLEN,3);
      //set the packet
      TR_String[0] = Freq;
      TR_String[1] = (int8)((PacketNmbr & 0xff00) >> 8);
      TR_String[2] = (int8)(PacketNmbr & 0x00ff);
      EZMacBuf_Write (&TR_String[0]);
      printf("TX frequency: %x, packet number: %x\n\r",Freq,PacketNmbr);
      //go to idle state
      EZMac_Idle();
      //start the TX
      EZMac_Transmit();     //state=idle?
      i=0;
      Transmitting = TRUE;
      while(Transmitting && (i<100))
      {
         EZMacReg_Read(MSR,&iRet);
         if (iRet==EZMac_S_TxError)
         {
			#ifndef EZMAC_LITE
             PrintErrorCounters(TRUE);
			#endif
            #ifdef END_HARDWARE
             Switch_2color_LED (RED);
            #else
             output_low (PIN_C5);
            #endif      //#ifdef END_HARDWARE
      		printf("TX_error\n\r");
            break;
            i++;
            delay_ms(20);
            #ifdef END_HARDWARE
            output_high (PIN_C5);                      //switch off red LED
            #else
            output_high (PIN_C1);                      //switch off
            #endif      //#ifdef END_HARDWARE
            EZMac_Transmit();     //state=idle?

         }
         if(iRet == EZMac_S_Idle)
            Transmitting = FALSE;
      }
      #ifdef END_HARDWARE
      output_high (PIN_C5);                      //switch off red LED
      #else
      output_high (PIN_C1);                      //switch off
      #endif      //#ifdef END_HARDWARE

      //inc the counters
      if(Freq < 0x03)
         Freq++;
      else
         Freq = 0;

      PacketNmbr++;
      #endif
   }
}

//===============================================================================================
void main(void)							// prg start point
{
   init_uart();
   enable_INT_RDA;
   MAIN_init();
   EZMac_SysInit();
   printf("\n\rEZmac Development 09/29/2006\n\r");
   EZMac_Config();
   Device_Test();
}




